/*********************************************************
*Copyright (C), 2019, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  iap
*  :  Quezf
*  :  V1.0
*  :  2019/7/8
*  :  IAP
          1.ʹES7P2032оƬIAPܣFLASHвдĲ.
		  2.ʵֶ0x0A00ʼַľҳ̣ȻȡõַݣǷдһ¡
*  ע:  ES7P2032
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

unsigned int RamBuff[16];         //Ram16
unsigned char IAP_failure;

union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashAddr;                       //Flashַ

union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashData;                       //Flashݱ

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/ 
void isr(void) interrupt
{
    if ( IAPIE && IAPIF  ) 
	{ 	
    	IAPIF = 0;                      //жϱ־
        if(PRGS_ERR || ERSS_ERR)
        {
            IAP_failure = 1; 
        }	    
	}
}

/********************************************************
:	void ram_clear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void ram_clear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/*********************************************************
:	void FlashWriteData(void)
  :	Flashд
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void FlashWriteData(void)
{
	unsigned char gie_bk = GIE;

	__asm{CWDT};		//幷
        
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }
	
	FRAL = FlashAddr.Byte[0];		//дʼַ
	FRAH = FlashAddr.Byte[1];

    FRAHN = ~FRAH;
    FRALN = ~FRAL;

    ROMDH = FlashData.Byte[1];    //д
    ROMDL = FlashData.Byte[0];

    ROMDHN = ~ROMDH;              //д
    ROMDLN = ~ROMDL;

	TOEN = 1;					//ʹTimeoutʱ
	IAPIE = 1;					//IAPжʹ
	IAPCLR = 1;					//IAP״̬

	IAPUL = 0xA5;				//
	while (IAPUL == 0);

	IAPPRGS = 0xD5;				//д
	__Asm NOP;
	
	while(!IAP_DONE)			//ȴ
	{
        if(IAP_LVDIF || PRGS_ERR)break;
	}

	IAPUL = 0x00;				//

	GIE = gie_bk;					//ȫж
}

/*********************************************************
:	void FlashReadData(void) 
  :	Flash
ֵ: 
ֵ: bufݻ
ֵ: 
**********************************************************/
void FlashReadData(void)
{
	unsigned char gie_bk = GIE;

	__asm{CWDT};		//幷
	
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

    FRAH = FlashAddr.Byte[1];    //öʼַ
    FRAL = FlashAddr.Byte[0];

	__Asm TBR;		             //

    FlashData.Byte[1] = ROMDH;
    FlashData.Byte[0] = ROMDL;

	GIE = gie_bk;					//ȫж
}

/*********************************************************
:	uchar FlashErasePage(void)
  :	Flash
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void FlashErasePage(void)
{
	unsigned char gie_bk = GIE;

	__asm{CWDT};		//幷
	
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

	FRAH = FlashAddr.Byte[1];
	FRAL = FlashAddr.Byte[0];

	FRAHN = ~FRAH;
	FRALN = ~FRAL;

	IAPIE = 1;
	IAPCLR = 1;

	IAPUL = 0xA5; 
	IAPERSS = 0xAE;

    while(!IAP_DONE)	//ȴ
    {
        if(IAP_LVDIF || ERSS_ERR)break;
    }
	IAPUL = 0x00;

    IAPIE = 0;          //ж

	GIE = gie_bk;			//ȫж
}

/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	unsigned char i;

	ram_clear();						// RAMʼ

	FlashAddr.Word = 0x1E00;            //ʼַ

    for(i=0;i<16;i++)
    {
        FlashReadData();                //Flash 
        RamBuff[i] = FlashData.Word;    //ݵǰRam
        FlashAddr.Word++;      
    }  

	FlashAddr.Word = 0x0A00;            //ʼַ 
	FlashErasePage();                   //ҳFlash

    for (i=0;i<16;i++)
    {
        RamBuff[i] = i;					//޸Ramǰ16ֽ
    }

    for(i=0;i<16;i++)
    {
        FlashData.Word = RamBuff[i];
        FlashWriteData();               //дFlash  
        FlashAddr.Word++;        
    }

    for (i=0;i<16;i++)
    {
        RamBuff[i] = 0;                 //޸Ram
    }

    FlashAddr.Word = 0x0A00;            //ʼַ 
    for(i=0;i<16;i++)
    {
        FlashReadData();                //ٴζFlash 
        RamBuff[i] = FlashData.Word;    //Ƿд
        FlashAddr.Word++;      
    }
	while (1)
	{
		__Asm CWDT;
	}
}